PROGRAM modbus_Master
VAR_EXTERNAL

END_VAR

VAR_GLOBAL

END_VAR

VAR

inst0_MODBUS_MASTER_INIT:MODBUS_MASTER_INIT;
inst1_MODBUS_MASTER_CTRL:MODBUS_MASTER_CTRL;


 first:bool:=false;
 mError:usint;
 
 mCtrl:bool:=false;
 mDone :bool:=false;
 
 modbusBuf : ARRAY[0..50] OF byte;
	data_Ptr : POINTER;
 
 DI0 AT %I0.0:byte;
 
 addr:dword;
 rw :usint;
 mCount:int;
 err:usint;
 
 
 
END_VAR
;

if first=false then
	inst0_MODBUS_MASTER_INIT(ENABLE :=1 , MODE := 1, PORT :=2 , BAUD :=115200 , DATABITS :=8 , PARITY :=0 , STOPBITS :=1  | mError := ERROR);
	first:=true;
	mCtrl:=true;
else

		data_Ptr:=&modbusBuf;
		if DI0>0 then
			mCtrl:=1;
			if DI0=1 then
				rw:=0;  (*read*)
				addr:=16#00001; (*read io 0 fc=1*)
				mCount:=1;
			elsif DI0=2 then
				rw:=0;  (*read*)
				addr:=16#10001; (*read io 0 fc=2*)
				mCount:=1;
			elsif DI0=4 then
				rw:=0;  (*read*)
				addr:=16#40001; (*read reg 0 fc=3*)
				mCount:=2;
			elsif DI0=8 then
				rw:=0;  (*read*)
				addr:=16#30001; (*read reg 0 fc=4*)
				mCount:=2;
			   
			elsif DI0=16 then
				rw:=1;  (*write*)
				addr:=16#00001; (*read io 0 fc=5*)
				mCount:=1;
				modbusBuf[0]:=16#ff;
				modbusBuf[1]:=16#00;
				
			elsif DI0=32 then
				rw:=1;  (*write*)
				addr:=16#00001; (*read io 0 fc=f*)
				mCount:=8;
				modbusBuf[0]:=16#01;
				modbusBuf[1]:=16#ff;
				
			elsif DI0=64 then
			
				rw:=1;  (*write*)
				addr:=16#40001; (*read io 0 fc=6*)
				mCount:=1;
				modbusBuf[0]:=16#01;
				modbusBuf[1]:=16#02;
			
			elsif DI0=128 then
			
				rw:=1;  (*write*)
				addr:=16#40001; (*read io 0 fc=10*)
				mCount:=2;
				modbusBuf[0]:=16#00;
				modbusBuf[1]:=16#01;	
				modbusBuf[2]:=16#00;
				modbusBuf[3]:=16#02;		
			end_if;
			
		else
		
			mCtrl:=0;
			
		end_if;
		
		if mCtrl=1 then
			err:=0;
		end_if;
		
		
		
		inst1_MODBUS_MASTER_CTRL(
			ENABLE :=mCtrl  (*发送数据使能，上升沿触发*)
			 , PORT :=2 (* 端口设置1=RS232，2=RS485*)
			 , SLAVEID :=1 (*从站id*)
			 , READWRITE :=rw (*0=读数据，1=写数据*)
			 , ADDRESS :=addr  (*PLC地址，例如：0x40001*)
			 , COUNT :=mCount  (*读写数量*)
			 , DATA_PTR :=data_Ptr(*输入输出数据*)  
			 |  mDone:= DONE(*0=正在执行，1=执行结束*)
			 , mError  := ERROR); (*0=无错误，错误信息*)

		if mError>0 then
			err:=mError;
		end_if;
		
end_if;


END_PROGRAM